;
;								EJEMPLO 16
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El manejo de la pantalla LCD
;
;Este ejemplo pretende introducirnos en el manejo de la pantalla LCD, para la visualizacin
;de diferentes mensajes (p.e. Hola).
;

			List	p=16F876A		;Tipo de procesador
			include	"P16F876A.INC"	;Definiciones de registros internos
                    		
Lcd_var		equ	0x20				;Variables (3) empleadas por las rutinas de manejo del LCD

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
		
			org	0x00				;Vector de RESET	
			goto	Inicio
			org	0x05

			include	"LCD_cxx.inc"	;Incluye las rutinas de manejo del LCD

Inicio	   	clrf 	PORTB		;Borra los latch de salida
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			movlw	0x06
			movwf	ADCON1		;Puerta A digital
			movlw	b'00110001'		
			movwf	TRISA		;RA1-RA3 salidas				
			bcf		STATUS,RP0	;Selecciona banco 0	
		
			call	UP_LCD		;Configura puertos para LCD
			call	LCD_INI		;Secuencia de inicio del LCD
			movlw	b'00001111'
			call	LCD_REG		;Enva instruccin: LCD ON, Cursor ON y blink ON		
			movlw	'H'
			call	LCD_DATO	;Visualiza H
			movlw	'o'
			call	LCD_DATO	;Visualiza o
			movlw	'l'
			call	LCD_DATO	;Visualiza l
			movlw	'a'
			call	LCD_DATO	;Visualiza a
			movlw	' '
			call	LCD_DATO	;Visualiza blanco
		
Loop		sleep				;Puesta en Standby

			end					;Fin del programa fuente

